<?php

namespace App\Http\Controllers;

use App\Models\Equipo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class EquipoController extends Controller{

    public function index(){
        $data = Equipo::all();
        return response()->json($data, 200);
    }
    public function store(Request $request) {
        $foto = '';
        if($request->foto_file != null) {
            $fondoName = 'equipo_' . time() . '.' . $request->foto_file->extension();
            $request->foto_file->move(public_path('images'), $fondoName);
            $foto = 'images/' . $fondoName;
        }
        $prog = new Equipo();
        $prog->equipo_nombre = $request->equipo_nombre;
        $prog->equipo_descripcion = $request->equipo_descripcion;
        $prog->equipo_foto = $foto;
        $prog->usuario_id = $request->usuario_id;
        $prog->save();
        return response()->json($prog, 200);
    }
    public function updateEquipo(Request $request) {
        $data = Equipo::find($request->id);
        $foto = '';
        if($request->equipo_foto == '') {
            if ($request->foto_file != null) {
                $fondoName = 'equipo_' . time() . '.' . $request->foto_file->extension();
                $request->foto_file->move(public_path('images'), $fondoName);
                $foto = 'images/' . $fondoName;
            }
            if($data['equipo_foto']!='') {
                if(File::exists($data['equipo_foto'])) {
                    File::delete($data['equipo_foto']);
                }
            }
        } else {
            $foto = $request->equipo_foto;
        }

        $prog = [
            'equipo_nombre'=>$request['equipo_nombre'],
            'equipo_foto'=> $foto,
            'equipo_descripcion' => $request['equipo_descripcion'],
            'usuario_id' => $request['usuario_id']
        ];
        $data->update($prog);
        return response()->json($data, 201);
    }
    public function destroy($id) {
        $data = Equipo::find($id);
        if($data['equipo_foto'] != '') {
            if(File::exists($data['equipo_foto'])) {
                File::delete($data['equipo_foto']);
            }
        }
        $data->delete();
        return response()->json(['success'=>true], 200);
    }
    public function show($id){
        $data = Equipo::find($id);
        return response()->json($data, 200);
    }
    public function mostrarEquipoUser($id){
        $data = Equipo::where('usuario_id','=',$id)->get();
        return response()->json($data, 200);
    }
}
