<?php

namespace App\Http\Controllers;

use App\Models\Geovalla;
use Illuminate\Http\Request;

class GeovallaController extends Controller{

    public function index(){
        $data = Geovalla::all();
        return response()->json($data, 200);
    }
    public function store(Request $request) {
        $geo = new Geovalla();
        $geo->geo_lat = $request->geo_lat;
        $geo->geo_lng = $request->geo_lng;
        $geo->geo_radio = $request->geo_radio;
        $geo->geo_nombre = $request->geo_nombre;
        $geo->geo_mensaje = $request->geo_mensaje;
        $geo->geo_titulo = $request->geo_titulo;
        $geo->usuario_id = $request->usuario_id;
        $geo->save();
        return response()->json($geo, 200);
    }
    public function updateGeovalla(Request $request) {
        $data = Geovalla::find($request->id);

        $geo = [
            'geo_lat'=>$request['geo_lat'],
            'geo_lng'=> $request['geo_lng'],
            'geo_radio' => $request['geo_radio'],
            'geo_nombre' => $request['geo_nombre'],
            'geo_mensaje' => $request['geo_mensaje'],
            'geo_titulo' => $request['geo_titulo'],
            'usuario_id' => $request['usuario_id']
        ];
        $data->update($geo);
        return response()->json($data, 201);
    }
    public function destroy($id) {
        $data = Geovalla::find($id);
        $data->delete();
        return response()->json(['success'=>true], 200);
    }
    public function show($id){
        $data = Geovalla::find($id);
        return response()->json($data, 200);
    }
    public function mostrarGeovallaUser($id){
        $data = Geovalla::where('usuario_id','=',$id)->get();
        return response()->json($data, 200);
    }
}
