<?php
namespace App\Http\Controllers;

use App\Models\Musica;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class MusicaController extends Controller{

    public function index(){
        $data = Musica::all();
        return response()->json($data, 200);
    }
    public function store(Request $request) {
        $foto = '';
        if($request->foto_file != null) {
            $fondoName = time() . '_musica.' . $request->foto_file->extension();
            $request->foto_file->move(public_path('images'), $fondoName);
            $foto = 'images/' . $fondoName;
        }
        $musica = new Musica();
        $musica->musica_titulo = $request->musica_titulo;
        $musica->musica_desc = $request->musica_desc;
        $musica->musica_url = $request->musica_url;
        $musica->musica_imagen = $foto;
        $musica->tipomusica_id = $request->tipomusica_id;
        $musica->save();
        return response()->json($musica, 200);
    }
    public function updateMusica(Request $request) {
        $data = Musica::find($request->id);
        $foto = '';
        if($request->musica_imagen == '') {
            if ($request->foto_file != null) {
                $fondoName = time() . '_musica.' . $request->foto_file->extension();
                $request->foto_file->move(public_path('images'), $fondoName);
                $foto = 'images/' . $fondoName;
            }
            if($data['musica_imagen']!='') {
                if(File::exists($data['musica_imagen'])) {
                    File::delete($data['musica_imagen']);
                }
            }
        } else {
            $foto = $request->musica_imagen;
        }

        $musica = [
            'musica_titulo' => $request['musica_titulo'],
            'musica_imagen'=> $foto,
            'musica_desc' => $request['musica_desc'],
            'musica_url' => $request['musica_url'],
            'tipomusica_id' => $request['tipomusica_id']
        ];
        $data->update($musica);
        return response()->json($data, 201);
    }
    public function destroy($id) {
        $data = Musica::find($id);
        if($data['musica_imagen'] != '') {
            if(File::exists($data['musica_imagen'])) {
                File::delete($data['musica_imagen']);
            }
        }
        $data->delete();
        return response()->json(['success'=>true], 200);
    }
    public function show($id){
        $data = Musica::find($id);
        return response()->json($data, 200);
    }
    public function mostrarMusicaUser($id){
        $data = Musica::where('tipomusica_id','=',$id)->get();
        return response()->json($data, 200);
    }
}
