<?php
namespace App\Http\Controllers;

use App\Models\Multiradio;
use App\Models\Podcast;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class PodcastController extends Controller{

    public function index(){
        $data = Podcast::all();
        return response()->json($data, 200);
    }
    public function store(Request $request) {
        $foto = '';
        if($request->foto_file != null) {
            $fondoName = time() . '_podcast.' . $request->foto_file->extension();
            $request->foto_file->move(public_path('images'), $fondoName);
            $foto = 'images/' . $fondoName;
        }
        $multi = new Podcast();
        $pod = new Podcast();
        $pod->pod_titulo = $request->pod_titulo;
        $pod->pod_desc = $request->pod_desc;
        $pod->pod_url = $request->pod_url;
        $pod->pod_imagen = $foto;
        $pod->usuario_id = $request->usuario_id;
        $pod->save();
        return response()->json($pod, 200);
    }
    public function updatePod(Request $request) {
        $data = Podcast::find($request->id);
        $foto = '';
        if($request->pod_imagen == '') {
            if ($request->foto_file != null) {
                $fondoName = time() . '_podcast.' . $request->foto_file->extension();
                $request->foto_file->move(public_path('images'), $fondoName);
                $foto = 'images/' . $fondoName;
            }
            if($data['pod_imagen']!='') {
                if(File::exists($data['pod_imagen'])) {
                    File::delete($data['pod_imagen']);
                }
            }
        } else {
            $foto = $request->pod_imagen;
        }

        $pod = [
            'pod_titulo' => $request['pod_titulo'],
            'pod_imagen'=> $foto,
            'pod_desc' => $request['pod_desc'],
            'pod_url' => $request['pod_url'],
            'usuario_id' => $request['usuario_id']
        ];
        $data->update($pod);
        return response()->json($data, 201);
    }
    public function destroy($id) {
        $data = Podcast::find($id);
        if($data['pod_imagen'] != '') {
            if(File::exists($data['pod_imagen'])) {
                File::delete($data['pod_imagen']);
            }
        }
        $data->delete();
        return response()->json(['success'=>true], 200);
    }
    public function show($id){
        $data = Podcast::find($id);
        return response()->json($data, 200);
    }
    public function mostrarPodcastUser($id){
        $data = Podcast::where('usuario_id','=',$id)->get();
        return response()->json($data, 200);
    }
}
