<?php

namespace App\Http\Controllers;

use App\Models\Multiradio;
use App\Models\Radio;
use App\Models\Geovalla;
use App\Models\Usuario;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class RadioController extends Controller{

    public function index(){
        $data = Radio::all();
        return response()->json($data, 200);
    }
    public function store(Request $request) {
        $fondo = '';
        if($request->hasFile('fondo_file')) {
            $fondoName = time() . 'fondo.' . $request->fondo_file->extension();
            $request->fondo_file->move(public_path('images'), $fondoName);
            $fondo = 'images/' . $fondoName;
        }
        $fondoSplash = '';
        if($request->hasFile('splash_file')) {
            $fondoSplashName = time() . 'splash.' . $request->splash_file->extension();
            $request->splash_file->move(public_path('images'), $fondoSplashName);
            $fondoSplash = 'images/' . $fondoSplashName;
        }
        //$data = Radio::create($request->all());
        $radio = new Radio();
        $radio->radio_fondo = $fondo;
        $radio->radio_splash = $fondoSplash;
        $radio->radio_nombre = $request->radio_nombre;
        $radio->radio_url = $request->radio_url;
        $radio->radio_video = $request->radio_video;
        $radio->radio_whatsapp = $request->radio_whatsapp;
        $radio->radio_facebook_url = $request->radio_facebook_url;
        $radio->radio_facebook_id = $request->radio_facebook_id;
        $radio->radio_web = $request->radio_web;
        $radio->radio_youtube = $request->radio_youtube;
        $radio->radio_instagram = $request->radio_instagram;
        $radio->radio_menu_nicio = $request->radio_menu_nicio;
        $radio->radio_menu_noticias = $request->radio_menu_noticias;
        $radio->radio_menu_programas = $request->radio_menu_programas;
        $radio->radio_menu_mensajes = $request->radio_menu_mensajes;
        $radio->radio_fondo_color = $request->radio_fondo_color;
        $radio->radio_splash_color = $request->radio_splash_color;
        $radio->radio_url_rss = $request->radio_url_rss;
        $radio->radio_onesignal_id = $request->radio_onesignal_id;
        $radio->radio_onesignal_apirest = $request->radio_onesignal_apirest;
        $radio->usuario_id= $request->usuario_id;
        $radio->save();
        return response()->json($radio, 201);
    }
    public function updateRadio(Request $request) {
        $data = Radio::find($request->id);

        $fondo = '';
        if($request->radio_fondo == '') {
            if($request->hasFile('fondo_file')) {
                $fondoName = time() . 'fondo.' . $request->fondo_file->extension();
                $request->fondo_file->move(public_path('images'), $fondoName);
                $fondo = 'images/' . $fondoName;
            }
            if($data['radio_fondo']!='') {
                if(File::exists($data['radio_fondo'])) {
                    File::delete($data['radio_fondo']);
                }
            }

        } else {
            $fondo = $request->radio_fondo;
        }

        $fondoSplash = '';
        if($request->radio_splash == '') {
            if ($request->hasFile('splash_file')) {
                $fondoSplashName = time() . 'splash.' . $request->splash_file->extension();
                $request->splash_file->move(public_path('images'), $fondoSplashName);
                $fondoSplash = 'images/' . $fondoSplashName;
            }
            if($data['radio_splash']!='') {
                if(File::exists($data['radio_splash'])) {
                    File::delete($data['radio_splash']);
                }
            }
        } else {
            $fondoSplash = $request->radio_splash;
        }
        $radio = [
            'radio_fondo' => $fondo,
            'radio_splash' => $fondoSplash,
            'radio_nombre' => $request['radio_nombre'],
            'radio_url' => $request['radio_url'],
            'radio_video' => $request['radio_video'],
            'radio_whatsapp' => $request['radio_whatsapp'],
            'radio_facebook_url' => $request['radio_facebook_url'],
            'radio_facebook_id' => $request['radio_facebook_id'],
            'radio_web' => $request['radio_web'],
            'radio_youtube' => $request['radio_youtube'],
            'radio_instagram' => $request['radio_instagram'],
            'radio_menu_nicio' => $request['radio_menu_nicio'],
            'radio_menu_noticias' => $request['radio_menu_noticias'],
            'radio_menu_programas' => $request['radio_menu_programas'],
            'radio_menu_mensajes' => $request['radio_menu_mensajes'],
            'radio_fondo_color' => $request['radio_fondo_color'],
            'radio_splash_color' => $request['radio_splash_color'],
            'radio_url_rss' => $request['radio_url_rss'],
            'radio_onesignal_id' => $request['radio_onesignal_id'],
            'radio_onesignal_apirest' => $request['radio_onesignal_apirest']
        ];
        $data->update($radio);
        return response()->json($data, 201);
    }
    public function destroy($id) {
        $data = Radio::find($id);
        if($data['radio_fondo']!='') {
            if(File::exists($data['radio_fondo'])) {
                File::delete($data['radio_fondo']);
            }
        }
        if($data['radio_splash']!='') {
            if(File::exists($data['radio_splash'])) {
                File::delete($data['radio_splash']);
            }
        }
        $data->delete();
        return response()->json(['success'=>true], 200);
    }
    public function show($id){
        $data = Radio::find($id);
        return response()->json($data, 200);
    }
   public function mostrarRadioUser($id){
        $data = Radio::where('usuario_id','=',$id)->get()->first();
        if($data) {
            $multi = Multiradio::where('usuario_id', '=', $id)
                ->get(['id', 'multiradio_imagen', 'multiradio_nombre', 'multiradio_url', 'multiradio_descripcion']);
            $data['multiradio'] = $multi;

            $geovallas = Geovalla::where('usuario_id', '=', $id)
                ->get(['id', 'geo_lat', 'geo_lng', 'geo_nombre', 'geo_titulo', 'geo_mensaje', 'geo_radio']);
            $data['geovalla'] = $geovallas;
        }
        return response()->json($data, 200);
    }
}
