<?php

namespace App\Http\Controllers;

use App\Models\Slide;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class SlideController extends Controller{

    public function index(){
        $data = Slide::all();
        return response()->json($data, 200);
    }
    public function store(Request $request) {
        $foto = '';
        if($request->foto_file != null) {
            $fondoName = time() . '.' . $request->foto_file->extension();
            $request->foto_file->move(public_path('images'), $fondoName);
            $foto = 'images/' . $fondoName;
        }
        $slide = new Slide();
        $slide->slide_foto = $foto;
        $slide->usuario_id = $request->usuario_id;
        $slide->save();
        return response()->json($slide, 200);
    }
    public function updateSlide(Request $request) {
        $data = Slide::find($request->id);
        $foto = '';
        if($request->prog_foto == '') {
            if ($request->foto_file != null) {
                $fondoName = time() . '.' . $request->foto_file->extension();
                $request->foto_file->move(public_path('images'), $fondoName);
                $foto = 'images/' . $fondoName;
            }
            if($data['slide_foto']!='') {
                if(File::exists($data['slide_foto'])) {
                    File::delete($data['slide_foto']);
                }
            }
        } else {
            $foto = $request->prog_foto;
        }

        $slide = [
            'slide_foto'=> $foto,
            'usuario_id' => $request['usuario_id']
        ];
        $data->update($slide);
        return response()->json($data, 201);
    }
    public function destroy($id) {
        $data = Slide::find($id);
        if($data['slide_foto'] != '') {
            if(File::exists($data['slide_foto'])) {
                File::delete($data['slide_foto']);
            }
        }
        $data->delete();
        return response()->json(['success'=>true], 200);
    }
    public function show($id){
        $data = Slide::find($id);
        return response()->json($data, 200);
    }
    public function mostrarSlidesUser($id){
        $data = Slide::where('usuario_id','=',$id)->get();
        return response()->json($data, 200);
    }
}
