<?php
namespace App\Http\Controllers;

use App\Models\Programa;
use App\Models\Radio;
use App\Models\Usuario;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;

class UsuarioController extends Controller {

    public function index(){
        return Usuario::all();
    }

    public function store(Request $request){
        $data = $request->all();
        $data['password'] = bcrypt($data['usuario_user']);
        $data2 = Usuario::create($data);
        return response()->json($data2, 200);
    }
    public function show($id){
        $data = Usuario::find($id);
        return response()->json($data, 200);
    }

    public function update(Request $request, $id) {
        $data = Usuario::find($id);
        $data->update($request->all());
        return response()->json($data, 201);
    }

    public function updatePassword(Request  $request, $id) {
        $user = $request->input('user');
        $pass = $request->input('password');
        $newpass = bcrypt($request->input('new_password'));
        if(Auth::attempt(['usuario_user'=>$user, 'password'=>$pass])){
            $data = Usuario::where('id','=',$id)
                    ->update(['password'=>$newpass]);
            return response()->json($data, 201);
        } else {
            return response()->json(['error'=>'No autorizado'], 401);
        }
    }
    public function destroy($id)
    {
        $us = Usuario::find($id);
        $radio = Radio::where('usuario_id', '=', $id)->get()->first();
        $progs = Programa::where('usuario_id', '=', $id)->get();
        if ($radio != null) {
            if ($radio['radio_fondo'] != '') {
                if (File::exists($radio['radio_fondo'])) {
                    File::delete($radio['radio_fondo']);
                }
            }
            if ($radio['radio_splash'] != '') {
                if (File::exists($radio['radio_splash'])) {
                    File::delete($radio['radio_splash']);
                }
            }
            $radio->delete();
        }
        foreach ($progs as $p){
            if($p['prog_foto'] != '') {
                if(File::exists($p['prog_foto'])) {
                    File::delete($p['prog_foto']);
                }
            }
            $p->delete();
        }
        $us->delete();
        return response()->json(['success'=>true], 200);
    }
    public function resetPassword(Request  $request, $id) {
        $user = bcrypt($request->input('user'));
        $data = Usuario::where('id','=',$id)
            ->update(['password'=>$user]);
        return response()->json($data, 201);
    }

    public function login() {
        if(Auth::attempt(['usuario_user'=>request('user'), 'password'=>request('password')])){
            $user = Auth::user();
            $token = $user->createToken('RadioPanel')->accessToken;
            return response()->json(['token'=>$token, 'user' => $user], 200);
        }else {
            return response()->json(['error'=>'No autorizado'], 401);
        }
    }
}
