<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;

class Usuario extends Authenticatable
{
    use HasFactory, HasApiTokens, Notifiable;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $fillable = [
        'usuario_nombre',
        'usuario_foto',
        'usuario_user',
        'password',
        'usuario_tipo'
    ];

    protected $casts = [
        'id' => 'integer',
    ];
    protected $hidden = [
        'password','remember_token'
    ];


    public function radios()
    {
        return $this->hasMany(\App\Models\Radio::class);
    }
    public function programas()
    {
        return $this->hasMany(\App\Models\Programa::class);
    }
    public function multiradios()
    {
        return $this->hasMany(\App\Models\Multiradio::class);
    }
	
    public function videos()
    {
        return $this->hasMany(\App\Models\Video::class);
    }
	public function podcast()
    {
        return $this->hasMany(\App\Models\Podcast::class);
    }
    public function equipos()
    {
        return $this->hasMany(\App\Models\Equipo::class);
    }
    public function mensajes()
    {
        return $this->hasMany(\App\Models\Mensaje::class);
    }
    public function geovallas()
    {
        return $this->hasMany(\App\Models\Geovalla::class);
    }
    public function multitvs()
    {
        return $this->hasMany(\App\Models\Multitv::class);
    }
}
