<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProgramasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::disableForeignKeyConstraints();

        Schema::create('programas', function (Blueprint $table) {
            $table->id();
            $table->string('prog_nombre')->nullable();
            $table->string('prog_foto')->nullable();
            $table->string('prog_horario_lu')->nullable();
            $table->string('prog_horario_ma')->nullable();
            $table->string('prog_horario_mi')->nullable();
            $table->string('prog_horario_ju')->nullable();
            $table->string('prog_horario_vi')->nullable();
            $table->string('prog_horario_sa')->nullable();
            $table->string('prog_horario_do')->nullable();
            $table->boolean('prog_lu')->default(false);
            $table->boolean('prog_ma')->default(false);
            $table->boolean('prog_mi')->default(false);
            $table->boolean('prog_ju')->default(false);
            $table->boolean('prog_vi')->default(false);
            $table->boolean('prog_sa')->default(false);
            $table->boolean('prog_do')->default(false);
            $table->foreignId('usuario_id')->constrained()->cascadeOnDelete()->cascadeOnUpdate();
            $table->timestamps();
        });

        Schema::enableForeignKeyConstraints();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('programas');
    }
}
